<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        h1 {
            text-align: center;
        }

        form {
            max-width: 400px;
            margin: 0 auto;
        }

        label {
            display: block;
            margin-top: 10px;
        }

        input[type="text"],
        input[type="number"],
        textarea {
            width: 100%;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 3px;
        }

        textarea {
            height: 100px;
        }

        input[type="file"] {
            margin-top: 5px;
        }

        input[type="submit"] {
            margin-top: 15px;
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 14px;
            cursor: pointer;
        }

        input[type="submit"]:hover {
            background-color: #45a049;
        }

        h3 {
            margin-top: 20px;
        }

        p {
            margin: 5px 0;
        }
    </style>
    <title>Delete existing Cabin</title>
</head>
<body>
    <h1>Delete existing Cabin</h1>

<?php
// Include the database configuration file
include "db.php";

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate and process the form data
    $cabinID = $_POST['cabinID'];

    // Prepare and execute the database delete statement
    $stmt = $con->prepare("DELETE FROM cabin WHERE cabinID = ?");
    $stmt->bind_param("i", $cabinID);

    // Check if the delete was successful
    if ($stmt->execute()) {
        echo "<h3>Cabin deleted successfully!</h3>";
    } else {
        echo "Error: " . $stmt->error;
    }

    // Close the statement
    $stmt->close();
}

// Fetch all available cabins from the database
$cabinQuery = "SELECT * FROM cabin";
$cabinResult = $con->query($cabinQuery);

// Check if any cabins exist
if ($cabinResult->num_rows > 0) {
    // Cabin selection form
    echo "<h2>Select a Cabin to Delete:</h2>";
    echo "<form method='POST'>";
    echo "<select name='cabinID' required>";
    echo "<option value=''>Select a Cabin</option>";

    // Display the cabin options in the dropdown list
    while ($row = $cabinResult->fetch_assoc()) {
        echo "<option value='" . $row['cabinID'] . "'>" . $row['cabinType'] . "</option>";
    }

    echo "</select>";
    echo "<input type='submit' value='Delete'>";
    echo "</form>";
}

$con->close();
?>