<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sunnspot Accommodation</title>
    <link href="https://fonts.googleapis.com/css?family=Quando&display=swap" rel="stylesheet">
    <link href="style.css" rel="stylesheet" type="text/css">
</head>

<body>
  <header> <img src="images/accommodation.png" alt="Accommodation">
    <h1>Sunnyspot Accommodation</h1>
  </header>

  <section>
    <?php
    include "db.php";
    // SQL query to retrieve all cabins
    $sql = "SELECT cabinType, cabinDescription, pricePerNight, pricePerWeek, photo FROM cabin";

    // Execute the query
    $result = $con->query($sql);

    // Check if any rows were returned
    if ($result->num_rows > 0) {
        // Output the data
        while ($row = $result->fetch_assoc()) {
            echo "<article>";
            echo "<h2>" . $row["cabinType"] . "</h2>";
            echo "<img src='images/" . $row["photo"] . "' alt='" . $row["cabinType"] . "'>";
            echo "<p><span>Details: </span>" . $row["cabinDescription"] . "</p>";
            echo "<p><span>Price per night: </span>$" . $row["pricePerNight"] . "</p>";
            echo "<p><span>Price per week: </span>$" . $row["pricePerWeek"] . "</p>";
            echo "</article>";
        }
    } else {
        echo "No cabins found.";
    }

    // Close the connection
    $con->close();
    ?>
  </section>
  
  <footer> 
    <a href="login.php">Admin</a> 
  </footer>
</body>
</html>