<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        h1 {
            text-align: center;
        }

        form {
            max-width: 400px;
            margin: 0 auto;
        }

        label {
            display: block;
            margin-top: 10px;
        }

        input[type="text"],
        input[type="number"],
        textarea {
            width: 100%;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 3px;
        }

        textarea {
            height: 100px;
        }

        input[type="file"] {
            margin-top: 5px;
        }

        input[type="submit"] {
            margin-top: 15px;
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 14px;
            cursor: pointer;
        }

        input[type="submit"]:hover {
            background-color: #45a049;
        }

        h3 {
            margin-top: 20px;
        }

        p {
            margin: 5px 0;
        }
    </style>
    <title>Update existing Cabin</title>
</head>
<body>
    <h1>Update existing Cabin</h1>

<?php
// Include the database configuration file
include "db.php";

// Fetch all available cabins from the database
$cabinQuery = "SELECT * FROM cabin";
$cabinResult = $con->query($cabinQuery);

// Check if any cabins exist
if ($cabinResult->num_rows > 0) {
    // Cabin selection form
    echo "<h2>Select a Cabin to Update:</h2>";
    echo "<form method='GET'>";
    echo "<select name='cabinID' required>";
    echo "<option value=''>Select a Cabin</option>";

    // Display the cabin options in the dropdown list
    while ($row = $cabinResult->fetch_assoc()) {
        echo "<option value='" . $row['cabinID'] . "'>" . $row['cabinType'] . "</option>";
    }

    echo "</select>";
    echo "<input type='submit' value='Update'>";
    echo "</form>";
}

// Check if a cabin is selected for update
if (isset($_GET['cabinID'])) {
    $cabinID = $_GET['cabinID'];

}

    // Fetch the selected cabin details from the database
    $selectedCabinQuery = "SELECT * FROM cabin WHERE cabinID = $cabinID";
    $selectedCabinResult = $con->query($selectedCabinQuery);

    // Check if the selected cabin exists
    if ($selectedCabinResult->num_rows > 0) {
        $selectedCabin = $selectedCabinResult->fetch_assoc();

        // Fetch all available inclusions from the database
        $inclusionQuery = "SELECT * FROM inclusion";
        $inclusionResult = $con->query($inclusionQuery);
    }

        // Fetch the inclusions associated with the selected cabin from the cabininclusion table
        $cabinInclusionQuery = "SELECT * FROM cabininclusion WHERE cabinID = $cabinID";
        $cabinInclusionResult = $con->query($cabinInclusionQuery);
        $selectedInclusions = array();
        while ($row = $cabinInclusionResult->fetch_assoc()) {
            $selectedInclusions[] = $row['incID'];
        }

       // Display the update form with the selected cabin details
echo "<h2>Update Cabin Details:</h2>";
echo "<form method='POST' enctype='multipart/form-data'>";
echo "<input type='hidden' name='cabinID' value='" . $selectedCabin['cabinID'] . "'>";
echo "<label for='cabinType'>Cabin Type:</label>";
echo "<input type='text' name='cabinType' value='" . $selectedCabin['cabinType'] . "' required><br>";

echo "<label for='cabinDescription'>Cabin Description:</label>";
echo "<textarea name='cabinDescription' required>" . $selectedCabin['cabinDescription'] . "</textarea><br>";

echo "<label for='pricePerNight'>Price per Night:</label>";
echo "<input type='number' name='pricePerNight' value='" . $selectedCabin['pricePerNight'] . "' required><br>";

echo "<label for='pricePerWeek'>Price per Week:</label>";
echo "<input type='number' name='pricePerWeek' value='" . $selectedCabin['pricePerWeek'] . "' required><br>";

echo "<label for='photo'>Cabin Photo:</label>";
echo "<input type='file' name='photo'><br>";

// Display the inclusions checkboxes
echo "<h3>Select Inclusions:</h3>";
while ($inclusion = $inclusionResult->fetch_assoc()) {
    echo "<input type='checkbox' name='inclusions[]' value='" . $inclusion['incID'] . "' ";
    if (in_array($inclusion['incID'], $selectedInclusions)) {
        echo "checked";
    }
    echo ">" . $inclusion['incName'] . "<br>";
}

echo "<br>";

echo "<input type='submit' value='Update Cabin'>";
echo "</form>";
echo "</body>";
echo "</html>";

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate and process the form data
    $cabinID = $_POST['cabinID'];
    $cabinType = $_POST['cabinType'];
    $cabinDescription = $_POST['cabinDescription'];
    $pricePerNight = $_POST['pricePerNight'];
    $pricePerWeek = $_POST['pricePerWeek'];
    $photo = $_FILES['photo'];
    $inclusions = $_POST['inclusions'];

    // Prepare and execute the database update statement
    $stmt = $con->prepare("UPDATE cabin SET cabinType=?, cabinDescription=?, pricePerNight=?, pricePerWeek=?, photo=? WHERE cabinID=?");
    $stmt->bind_param("ssddsi", $cabinType, $cabinDescription, $pricePerNight, $pricePerWeek, $photo['name'], $cabinID);

    // Check if the update was successful
    if ($stmt->execute()) {
        // Move the uploaded photo to the desired directory
        if (!empty($photo['name'])) {
            $targetDir = "images/";
            $targetFile = $targetDir . basename($photo['name']);
            move_uploaded_file($photo['tmp_name'], $targetFile);
        }

        // Delete all existing inclusions associated with the cabin from the cabininclusion table
        $deleteQuery = "DELETE FROM cabininclusion WHERE cabinID = $cabinID";
        $con->query($deleteQuery);

       // Insert the updated inclusions for the cabin into the cabininclusion table
       if (!empty($inclusions)) {
        $insertQuery = "INSERT INTO cabininclusion (cabinID, incID) VALUES ";
        $values = array();
        foreach ($inclusions as $incID) {
            $values[] = "($cabinID, $incID)";
        }
        $insertQuery .= implode(",", $values);
        $con->query($insertQuery);
    }

    echo "<h3>Cabin updated successfully!</h3>";
    echo "<p>Cabin ID: $cabinID</p>";
    echo "<p>Cabin Type: $cabinType</p>";
    echo "<p>Cabin Description: $cabinDescription</p>";
    echo "<p>Price per Night: $pricePerNight</p>";
    echo "<p>Price per Week: $pricePerWeek</p>";
    echo "<p>Photo: " . $photo['name'] . "</p>";
    echo "<p>Inclusions: " . implode(", ", $inclusions) . "</p>";
} else {
    echo "Error: " . $stmt->error;
}

// Close the statement
$stmt->close();
}

$con->close();
?>
