<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        h1 {
            text-align: center;
        }

        form {
            max-width: 400px;
            margin: 0 auto;
        }

        label {
            display: block;
            margin-top: 10px;
        }

        input[type="text"],
        input[type="number"],
        textarea {
            width: 100%;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 3px;
        }

        textarea {
            height: 100px;
        }

        input[type="file"] {
            margin-top: 5px;
        }

        input[type="submit"] {
            margin-top: 15px;
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 14px;
            cursor: pointer;
        }

        input[type="submit"]:hover {
            background-color: #45a049;
        }

        h3 {
            margin-top: 20px;
        }

        p {
            margin: 5px 0;
        }
    </style>
    <title>Insert New Cabin</title>
</head>
<body>
    <h1>Insert New Cabin</h1>

    <?php
    // Include the database configuration file
    include "db.php";

    // Fetch the list of inclusions from the 'inclusion' table
    $inclusionQuery = "SELECT * FROM inclusion";
    $inclusionResult = $con->query($inclusionQuery);
    $inclusions = $inclusionResult->fetch_all(MYSQLI_ASSOC);

    // Check if the form is submitted
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Validate and process the form data
        $cabinType = $_POST['cabinType'];
        $cabinDescription = $_POST['cabinDescription'];
        $pricePerNight = $_POST['pricePerNight'];
        $pricePerWeek = $_POST['pricePerWeek'];
        $photo = $_FILES['photo'];
        $selectedInclusions = $_POST['inclusions'];

        // Prepare and execute the database insert statement for cabin table
        $cabinStmt = $con->prepare("INSERT INTO cabin (cabinType, cabinDescription, pricePerNight, pricePerWeek, photo) VALUES (?, ?, ?, ?, ?)");
        $cabinStmt->bind_param("ssdds", $cabinType, $cabinDescription, $pricePerNight, $pricePerWeek, $photo['name']);

        // Check if the insert into cabin table was successful
        if ($cabinStmt->execute()) {
            $cabinID = $con->insert_id; // Get the auto-generated cabinID

            // Prepare and execute the database insert statement for cabininclusion table
            $cabinInclusionStmt = $con->prepare("INSERT INTO cabininclusion (cabinID, incID) VALUES (?, ?)");

            // Insert each selected inclusion into the cabininclusion table
            foreach ($selectedInclusions as $incID) {
                $cabinInclusionStmt->bind_param("ii", $cabinID, $incID);
                $cabinInclusionStmt->execute();
            }

            // Move the uploaded photo to the desired directory
            $targetDir = "images/";
            $targetFile = $targetDir . basename($photo['name']);
            move_uploaded_file($photo['tmp_name'], $targetFile);

            echo "<h3>Cabin inserted successfully!</h3>";
            echo "<p>Cabin Type: $cabinType</p>";
            echo "<p>Cabin Description: $cabinDescription</p>";
            echo "<p>Price per Night: $pricePerNight</p>";
            echo "<p>Price per Week: $pricePerWeek</p>";
            echo "<p>Photo: " . $photo['name'] . "</p>";
            echo "<p>Inclusions:</p>";
            echo "<ul>";
foreach ($selectedInclusions as $incID) {
    // Find the inclusion details from the fetched inclusions
    $inclusionDetails = array_filter($inclusions, function ($inclusion) use ($incID) {
        return $inclusion['incID'] == $incID;
    });

    if (count($inclusionDetails) > 0) {
        $inclusionDetail = reset($inclusionDetails);
        echo "<li>Inclusion Name: " . $inclusionDetail['incName'] . "</li>";
        echo "<li>Inclusion Details: " . $inclusionDetail['incDetails'] . "</li>";
    }
}
echo "</ul>";
} else {
    echo "Error: " . $cabinStmt->error;
}

// Close the statements
$cabinStmt->close();
$cabinInclusionStmt->close();
}

?>

<form method="POST" enctype="multipart/form-data">
    <label for="cabinType">Cabin Type:</label>
    <input type="text" name="cabinType" required><br>

    <label for="cabinDescription">Cabin Description:</label>
    <textarea name="cabinDescription" required></textarea><br>

    <label for="pricePerNight">Price per Night:</label>
    <input type="number" name="pricePerNight" required><br>

    <label for="pricePerWeek">Price per Week:</label>
    <input type="number" name="pricePerWeek" required><br>

    <label for="photo">Cabin Photo:</label>
    <input type="file" name="photo" required><br>

    <label for="inclusions">Inclusions:</label><br>
    <?php
    // Display the list of inclusions as checkboxes
    foreach ($inclusions as $inclusion) {
        echo '<input type="checkbox" name="inclusions[]" value="' . $inclusion['incID'] . '"> ' . $inclusion['incName'] . '<br>';
    }
    ?>

    <input type="submit" value="Insert Cabin">
</form>
</body>
</html>